﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Helion;
using System.Data.Linq.Mapping;

namespace PlikTekstowyDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            PlikTekstowy txt = new PlikTekstowy("tabela.txt");
            string s = "Informacje o danych z pliku:\n";
            s += "Ilość wierszy (rekordów): " + txt.IloscRekordow + "\n";
            s += "Ilość kolumn (pól): " + txt.IloscKolumn + "\n";

            //naglowek         
            s += "\nKolumny:\n";
            for (int i = 0; i < txt.IloscKolumn; ++i)
                s += i.ToString() + " " + txt.NazwyKolumn[i] + "(" + txt.TypyKolumn[i].Name + ")\n";

            //wiersz
            s += "\nPierwszy wiersz:\n";
            List<string> wiersz0 = txt.PobierzWiersz(0);
            foreach (string komorka in wiersz0) s += komorka + "\t";

            //tabela
            s += "\n\nCała tabela:\n";
            foreach (List<string> wiersz in txt.Tabela)
            {
                foreach (string komorka in wiersz) s += komorka + "\t";
                s += "\n";
            }
            MessageBox.Show(s);

            //sortowanie
            List<List<string>> posortowanaTabela = txt.Sortuj(a => a.Length, 1);

            s = "Tabela po sortowaniu:\n";
            foreach (List<string> wiersz in posortowanaTabela)
            {
                foreach (string komorka in wiersz) s += komorka + "\t";
                s += "\n";
            }
            MessageBox.Show(s);
        }


        //Przyklad klasy implementujacej interfejs ILinqToTxt
        class Osoba : Helion.ILinqToTxt
        {
            #region Pola
            private int id;
            private string imie;
            private string nazwisko;
            private int numerTelefonu;
            private int wiek;
            #endregion

            #region Wlasnosci
            public int Id
            {
                get { return id; }
                set { id = value; }
            }

            public string Imie
            {
                get { return imie; }
                set { imie = value; }
            }

            public string Nazwisko
            {
                get { return nazwisko; }
                set { nazwisko = value; }
            }

            public int NumerTelefonu
            {
                get { return numerTelefonu; }
                set { numerTelefonu = value; }
            }

            public int Wiek
            {
                get { return wiek; }
                set { wiek = value; }
            }
            #endregion

            #region Składowe ILinqToTxt
            public string MapowanieKolumn(string nazwaWlasnosci)
            {
                switch (nazwaWlasnosci)
                {
                    case "Id": return "Id";
                    case "Imie": return "Imie";
                    case "Nazwisko": return "Nazwisko";
                    case "Wiek": return "Wiek";
                    case "NumerTelefonu": return "NumerTelefonu";
                    default: return string.Empty;
                }
            }

            public void UstawWartoscPola(string nazwaKolumny, object dane)
            {
                switch (nazwaKolumny)
                {
                    case "Id": this.id = Int32.Parse(dane as string); break;
                    case "Imie": this.imie = dane as string; break;
                    case "Nazwisko": this.nazwisko = dane as string; break;
                    case "Wiek": this.wiek = Int32.Parse(dane as string); break;
                    case "NumerTelefonu": this.numerTelefonu = Int32.Parse(dane as string); break;
                    default: break;
                }
            }

            public string NazwaTabeli
            {
                get { return "ListaOsob"; }
            }
            #endregion
        }


        /*
        [Table(Name = "ListaOsob")]
        class Osoba2
        {
            [Column(Name = "Id")]
            public int Id;
            [Column(Name = "Imie")]
            public string Imie;
            [Column(Name = "Nazwisko")]
            public string Nazwisko;
            [Column(Name = "NumerTelefonu")]
            public int NumerTelefonu;
            [Column(Name = "Wiek")]
            public int Wiek;
        }
        */

        [Table(Name = "ListaOsob")]
        class Osoba2
        {
            private int id;
            private string imie;
            private string nazwisko;
            private int numerTelefonu;
            private int wiek;

            [Column(Name = "Id")]
            public int Id
            {
                get { return id; }
                set { id = value; }
            }

            [Column(Name = "Imie")]
            public string Imie
            {
                get { return imie; }
                set { imie = value; }
            }

            [Column(Name = "Nazwisko")]
            public string Nazwisko
            {
                get { return nazwisko; }
                set { nazwisko = value; }
            }

            [Column(Name = "NumerTelefonu")]
            public int NumerTelefonu
            {
                get { return numerTelefonu; }
                set { numerTelefonu = value; }
            }

            [Column(Name = "Wiek")]
            public int Wiek
            {
                get { return wiek; }
                set { wiek = value; }
            }
        }
    }
}
